/**
 * @author student
/*******************************************************************************
 * Copyright (c) 2003 Clearfield Knowledge Solutions.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.k.co.nz/
 *******************************************************************************/
/* * 
 * Copyright: Copyright (c) 2003
 * Company  : Clearfield Knowledge Solutions
 * @author  : Student
 * @version : 1.0
 * Date Created : Jul 8, 2003
 * Title : JavaBean.Customer_Data.java
 * Desprition : This JavaBean class is responsible for getting and setting
 * properties realted to Customer Data .
 * 
 */
package JavaBeans;
/**
 * @author student
 *
 * This class is being used as a javabean for storing data related to a customer.
 * 
 */
public class Customer_Data {
	private String firstName;
	private String lastName;
	private String password;
	private String verifier;
	private String userName;
	private int ncbId;
	private String preBillingAmount;
	private double account;
	private CoffeePreference_Data preference;

	public Customer_Data() {
	}

	
	/**
	 * This method is being used for setting the firstName field.
	 * @param fName Customer first name.
	 * @return void
	 */
	public void setFirstName(String fName) {
		this.firstName = fName;
	}
	
	
	/**
	 * This method is being used for getting the firstName field.
	 * @return String Customer first name.
	 */
	public String getFirstName() {
		return this.firstName;
	}

	/**
	 * This method is being used for setting the lastName field.
	 * @param lName Customer last name.
	 * @return void
	 */
	public void setLastName(String lName) {
		this.lastName = lName;
	}
	
	
	/**
	 * This method is being used for getting the lastName field.
	 * @return String Customer last name.
	 */
	public String getLastName() {
		return this.lastName;
	}
	
	
	/**
	 * This method is being used for setting the password field.
	 * @param pwd Customer password.
	 * @return void
	 */
	public void setPassword(String pwd) {
		this.password = pwd;
	}
	
	
	/**
	 * This method is being used for getting the password field.
	 * @return String Customer password.
	 */
	public String getPassword() {
		return this.password;
	}
	
	/**
	 * This method is being used for setting the username field.
	 * @param uName Customer user name.
	 * @return void
	 */
	public void setUserName(String uName) {
		this.userName = uName;
	}
	
	/**
	 * This method is being used for getting the username field.
	 * @return String Customer user name.
	 */
	public String getUserName() {
		return this.userName;
	}

	
	/**
	 * This method is being used for setting the preference field.
	 * @param coffee Customer's coffee preference.
	 * @return void
	 */
	public void setPreference(CoffeePreference_Data coffee) {
		this.preference = coffee;
	}
	
	
	/**
	 * This method is being used for getting the preference field.
	 * @return CoffeePreference_Data Customer's coffee preference.
	 */
	public CoffeePreference_Data getPreference() {
		return this.preference;
	}

	/**
	 * This method is being used for setting the preBillingAmount field.
	 * @param pre Customer's prebilling amount.
	 * @return void
	 */
	public void setPreBillingAmount(String pre) {
		this.preBillingAmount = pre;
	}
	
	
	/**
	 * This method is being used for getting the preBillingAmount field.
	 * @return String Customer's prebilling amount.
	 */
	public String getPreBillingAmount() {
		return this.preBillingAmount;
	}

	
	/**
	 * This method is being used for setting the ncbId field.
	 * @param ncbid Customer's Ncb Id assigned by TMS.
	 * @return void
	 */
	public void setNcbId(int ncbid) {
		this.ncbId = ncbid;
	}
	
	/**
	 * This method is being used for getting the ncbid field.
	 * @return int
	 */
	public int getNcbId() {
		return this.ncbId;
	}
	
	/**
	 * This method is being used for setting the verifier field.
	 * @param ver Customer's password verifier.
	 * @return void
	 */
	public void setVerifier(String ver) {
		this.verifier = ver;
	}
	
	
	/**
	 * This method is being used for getting the verifier field.
	 * @return String Customer's password verifier.
	 */
	public String getVerifier() {
		return this.verifier;
	}


	/**
	 * This method is being used for setting the account field.
	 * @param acc Customer's account balance.
	 * @return void
	 */
	public void setAccount(double acc) {
		this.account = acc;
	}
	
	
	/**
	 * This method is being used for getting the account field.
	 * @return double Customer's account balance.
	 */
	public double getAccount() {
		return this.account;
	}
}
